/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.ScriptContext;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class Bug1362 {
    private static double speed;
    private static final int DATASET_SIZE = 10000;

    private static ProgressMonitor getMonitor(String label) {
        return new NullProgressMonitorImpl(label);
    }

    public static void main(String[] args) throws InterruptedException {
        try {
            int size = 500;
            args = new String[]{"multi"};
            if (args.length == 0) {
                System.err.println("args[0] should be four,eight or, multi");
                System.exit(1);
            }
            if (args[0].equals("multi")) {
                double[] speedArrayMulti = new double[size];
                for (int i = 0; i < size; ++i) {
                    System.err.println("=== " + i + " ===");
                    Bug1362.fftMultiThread(8);
                    speedArrayMulti[i] = speed;
                    System.err.println("Multi threads: " + i + " " + speed);
                    QDataSet timesMulti = Ops.dataset((Object)speedArrayMulti);
                    ScriptContext.formatDataSet(timesMulti, "/tmp/multi.txt");
                }
            } else if (args[0].equals("two")) {
                double[] speedArray2 = new double[size];
                for (int i = 0; i < size; ++i) {
                    Bug1362.doTwoThreads();
                    speedArray2[i] = speed;
                    QDataSet timesTwo = Ops.dataset((Object)speedArray2);
                    ScriptContext.formatDataSet(timesTwo, "/tmp/twoThreads.txt");
                }
            } else if (args[0].equals("four")) {
                double[] speedArray4 = new double[size];
                for (int i = 0; i < size; ++i) {
                    Bug1362.doFourThreads();
                    speedArray4[i] = speed;
                    QDataSet timesFour = Ops.dataset((Object)speedArray4);
                    ScriptContext.formatDataSet(timesFour, "/tmp/fourThreads.txt");
                }
            } else if (args[0].equals("eight")) {
                double[] speedArray8 = new double[size];
                for (int i = 0; i < size; ++i) {
                    Bug1362.doEightThreads();
                    speedArray8[i] = speed;
                    QDataSet timesEight = Ops.dataset((Object)speedArray8);
                    ScriptContext.formatDataSet(timesEight, "/tmp/eightThreads.txt");
                }
            } else {
                System.err.println("args[0] should be four,eight or, multi");
            }
            ScriptContext.setLayout(4, 1);
            ScriptContext.getDocumentModel().getPlots(2).getYaxis().setRange(DatumRange.newDatumRange((double)0.0, (double)10.0, (Units)Units.dimensionless));
            try {
                ScriptContext.writeToPng("/tmp/Experiment1.png");
            }
            catch (IOException ex) {
                Logger.getLogger(Bug1362.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Bug1362.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void doTwoThreads() throws InterruptedException {
        final QDataSet ds = Ops.ripplesWaveformTimeSeries((int)10000);
        ProgressMonitor mon0 = Bug1362.getMonitor("original task");
        long t0 = System.currentTimeMillis();
        QDataSet out = Ops.fftPower((QDataSet)ds, (int)512, (ProgressMonitor)mon0);
        while (!mon0.isFinished()) {
            Thread.sleep(200L);
        }
        long time = System.currentTimeMillis() - t0;
        ScriptContext.setLayout(3, 1);
        ScriptContext.plot(0, out);
        final ProgressMonitor mon1 = Bug1362.getMonitor("task 1");
        final ProgressMonitor mon2 = Bug1362.getMonitor("task 2");
        Runnable run1 = new Runnable(){

            @Override
            public void run() {
                try {
                    QDataSet qDataSet = Ops.fftPower((QDataSet)ds.trim(0, 5000), (int)512, (ProgressMonitor)mon1);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Runnable run2 = new Runnable(){

            @Override
            public void run() {
                try {
                    QDataSet qDataSet = Ops.fftPower((QDataSet)ds.trim(5000, 10000), (int)512, (ProgressMonitor)mon2);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        t0 = System.currentTimeMillis();
        new Thread(run1).start();
        new Thread(run2).start();
        while (!mon1.isFinished() && !mon2.isFinished()) {
            Thread.sleep(200L);
        }
        long time1 = System.currentTimeMillis() - t0;
        speed = (double)time / (double)time1;
    }

    private static void fftMultiThread(int threads) throws InterruptedException {
        ArrayList<3> run = new ArrayList<3>();
        final ArrayList<ProgressMonitor> mon = new ArrayList<ProgressMonitor>();
        final QDataSet ds = Ops.ripplesWaveformTimeSeries((int)10000);
        final QDataSet[] out = new QDataSet[threads + 1];
        ProgressMonitor temp = Bug1362.getMonitor("original task");
        mon.add(temp);
        long t0 = System.currentTimeMillis();
        out[0] = Ops.copy((QDataSet)Ops.fftPower((QDataSet)ds, (int)512, (ProgressMonitor)((ProgressMonitor)mon.get(0))));
        while (!((ProgressMonitor)mon.get(0)).isFinished()) {
            Thread.sleep(200L);
        }
        long time = System.currentTimeMillis() - t0;
        ScriptContext.setLayout(threads + 1, 1);
        ScriptContext.plot(0, out[0]);
        long time0 = System.currentTimeMillis();
        for (int i = 0; i < threads; ++i) {
            temp = Bug1362.getMonitor("task" + (i + 1));
            mon.add(temp);
            final int j = i + 1;
            final int thr = threads;
            Runnable run0 = new Runnable(){

                @Override
                public void run() {
                    try {
                        out[j] = Ops.copy((QDataSet)Ops.fftPower((QDataSet)ds.trim((j - 1) * 10000 / thr, j * 10000 / thr), (int)512, (ProgressMonitor)((ProgressMonitor)mon.get(j))));
                        ScriptContext.plot(j, out[j]);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            };
            run.add(run0);
            if (i == 0) {
                t0 = System.currentTimeMillis();
            }
            new Thread((Runnable)run.get(i)).start();
        }
        System.err.println("time: " + (System.currentTimeMillis() - time0));
        while (!Bug1362.isFinished(mon.toArray(new ProgressMonitor[mon.size()]))) {
            Thread.sleep(200L);
        }
        long time1 = System.currentTimeMillis() - t0;
        speed = (double)time / (double)time1;
        try {
            ScriptContext.writeToPng("/tmp/Experiment1_graphs.png");
        }
        catch (IOException ex) {
            Logger.getLogger(Bug1362.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void doFourThreads() throws InterruptedException {
        final QDataSet ds = Ops.ripplesWaveformTimeSeries((int)10000);
        ProgressMonitor mon0 = Bug1362.getMonitor("original task");
        long t0 = System.currentTimeMillis();
        QDataSet out = Ops.fftPower((QDataSet)ds, (int)512, (ProgressMonitor)mon0);
        while (!mon0.isFinished()) {
            Thread.sleep(200L);
        }
        long time = System.currentTimeMillis() - t0;
        ScriptContext.setLayout(5, 1);
        final ProgressMonitor mon1 = Bug1362.getMonitor("task 1");
        final ProgressMonitor mon2 = Bug1362.getMonitor("task 2");
        final ProgressMonitor mon3 = Bug1362.getMonitor("task 3");
        final ProgressMonitor mon4 = Bug1362.getMonitor("task 4");
        Runnable run1 = new Runnable(){

            @Override
            public void run() {
                try {
                    QDataSet qDataSet = Ops.fftPower((QDataSet)ds.trim(0, 2500), (int)512, (ProgressMonitor)mon1);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Runnable run2 = new Runnable(){

            @Override
            public void run() {
                try {
                    QDataSet qDataSet = Ops.fftPower((QDataSet)ds.trim(2500, 5000), (int)512, (ProgressMonitor)mon2);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Runnable run3 = new Runnable(){

            @Override
            public void run() {
                try {
                    QDataSet qDataSet = Ops.fftPower((QDataSet)ds.trim(5000, 7500), (int)512, (ProgressMonitor)mon3);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Runnable run4 = new Runnable(){

            @Override
            public void run() {
                try {
                    QDataSet qDataSet = Ops.fftPower((QDataSet)ds.trim(7500, 10000), (int)512, (ProgressMonitor)mon4);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        t0 = System.currentTimeMillis();
        new Thread(run1).start();
        new Thread(run2).start();
        new Thread(run3).start();
        new Thread(run4).start();
        while (!(mon1.isFinished() || mon2.isFinished() || mon3.isFinished() || mon4.isFinished())) {
            Thread.sleep(200L);
        }
        long time1 = System.currentTimeMillis() - t0;
        speed = (double)time / (double)time1;
    }

    private static void doEightThreads() throws InterruptedException {
        final QDataSet ds = Ops.ripplesWaveformTimeSeries((int)10000);
        ProgressMonitor mon0 = Bug1362.getMonitor("original task");
        long t0 = System.currentTimeMillis();
        QDataSet out = Ops.fftPower((QDataSet)ds, (int)512, (ProgressMonitor)mon0);
        while (!mon0.isFinished()) {
            Thread.sleep(200L);
        }
        long time = System.currentTimeMillis() - t0;
        ScriptContext.setLayout(5, 1);
        final ProgressMonitor mon1 = Bug1362.getMonitor("task 1");
        final ProgressMonitor mon2 = Bug1362.getMonitor("task 2");
        final ProgressMonitor mon3 = Bug1362.getMonitor("task 3");
        final ProgressMonitor mon4 = Bug1362.getMonitor("task 4");
        final ProgressMonitor mon5 = Bug1362.getMonitor("task 5");
        final ProgressMonitor mon6 = Bug1362.getMonitor("task 6");
        final ProgressMonitor mon7 = Bug1362.getMonitor("task 7");
        final ProgressMonitor mon8 = Bug1362.getMonitor("task 8");
        Runnable run1 = new Runnable(){

            @Override
            public void run() {
                try {
                    QDataSet qDataSet = Ops.fftPower((QDataSet)ds.trim(0, 1250), (int)512, (ProgressMonitor)mon1);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Runnable run2 = new Runnable(){

            @Override
            public void run() {
                try {
                    QDataSet qDataSet = Ops.fftPower((QDataSet)ds.trim(1250, 2500), (int)512, (ProgressMonitor)mon2);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Runnable run3 = new Runnable(){

            @Override
            public void run() {
                try {
                    QDataSet qDataSet = Ops.fftPower((QDataSet)ds.trim(2500, 3750), (int)512, (ProgressMonitor)mon3);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Runnable run4 = new Runnable(){

            @Override
            public void run() {
                try {
                    QDataSet qDataSet = Ops.fftPower((QDataSet)ds.trim(3750, 5000), (int)512, (ProgressMonitor)mon4);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Runnable run5 = new Runnable(){

            @Override
            public void run() {
                try {
                    QDataSet qDataSet = Ops.fftPower((QDataSet)ds.trim(5000, 6250), (int)512, (ProgressMonitor)mon5);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Runnable run6 = new Runnable(){

            @Override
            public void run() {
                try {
                    QDataSet qDataSet = Ops.fftPower((QDataSet)ds.trim(6250, 7500), (int)512, (ProgressMonitor)mon6);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Runnable run7 = new Runnable(){

            @Override
            public void run() {
                try {
                    QDataSet qDataSet = Ops.fftPower((QDataSet)ds.trim(7500, 8750), (int)512, (ProgressMonitor)mon7);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        Runnable run8 = new Runnable(){

            @Override
            public void run() {
                try {
                    QDataSet qDataSet = Ops.fftPower((QDataSet)ds.trim(8750, 10000), (int)512, (ProgressMonitor)mon8);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        t0 = System.currentTimeMillis();
        new Thread(run1).start();
        new Thread(run2).start();
        new Thread(run3).start();
        new Thread(run4).start();
        new Thread(run5).start();
        new Thread(run6).start();
        new Thread(run7).start();
        new Thread(run8).start();
        while (!Bug1362.isFinished(new ProgressMonitor[]{mon1, mon2, mon3, mon4, mon5, mon6, mon7, mon8})) {
            Thread.sleep(200L);
        }
        long time1 = System.currentTimeMillis() - t0;
        speed = (double)time / (double)time1;
    }

    private static boolean isFinished(ProgressMonitor[] mons) {
        boolean finished = true;
        for (ProgressMonitor m : mons) {
            if (m.isFinished()) continue;
            finished = false;
        }
        return finished;
    }

    private static class NullProgressMonitorImpl
    extends NullProgressMonitor {
        long t0 = System.currentTimeMillis();
        String label;

        public NullProgressMonitorImpl(String label) {
            this.label = label;
        }

        public void setTaskProgress(long position) throws IllegalArgumentException {
            long t = System.currentTimeMillis();
            if (t - this.t0 > 500L) {
                this.t0 = t;
                System.err.println(this.label + " " + position + " of " + this.getTaskSize());
            }
        }
    }
}

